<?php
/**
 * Include and setup custom metaboxes and fields. (make sure you copy this file to outside the CMB2 directory)
 *
 * Be sure to replace all instances of 'yourprefix_' with your project's prefix.
 * http://nacin.com/2010/05/11/in-wordpress-prefix-everything/
 *
 * @category YourThemeOrPlugin
 * @package  Demo_CMB2
 * @license  http://www.opensource.org/licenses/gpl-license.php GPL v2.0 (or later)
 * @link     https://github.com/WebDevStudios/CMB2
 */

/**
 * Get the bootstrap! If using the plugin from wordpress.org, REMOVE THIS!
 */

if ( file_exists( get_template_directory() . '/framework/cmb2/init.php' ) ) {
	require_once  get_template_directory() . '/framework/cmb2/init.php';
} elseif ( file_exists(  get_template_directory() . '/framework/includes/CMB2/init.php' ) ) {
	require_once  get_template_directory() . '/framework/includes/CMB2/init.php';
}

add_action( 'cmb2_admin_init', 'littleones_register_post_metabox' );
/**
 * Hook in and add a metabox to add fields to the post pages
 */
function littleones_register_post_metabox() {
	$prefix = 'littleones_';

	/**
    * Initiate the metabox
    */
	$cmb_post = new_cmb2_box( array(
		'id'            => $prefix.'post_metabox',
        'title'         => __( 'Header', 'cmb2' ),
        'object_types'  => array( 'post', ), // Post type
        'context'       => 'normal',
	) );
	$cmb_post->add_field( array(
	    'name'    => 'Header Image',
	    'desc'    => 'Upload an image or enter an URL.',
	    'id'      => $prefix . 'header_image',
	    'type'    => 'file',
	    // Optional:
	    'options' => array(
	        'url' => true, // Hide the text input for the url
	        // 'add_upload_file_text' => 'Add File' // Change upload button text. Default: "Add or Upload File"
	    ),
	) );
}

add_action( 'cmb2_admin_init', 'littleones_register_page_metabox' );
/**
 * Hook in and add a metabox to add fields to the post pages
 */
function littleones_register_page_metabox() {
	$prefix = 'littleones_';

	/**
    * Initiate the metabox
    */
	$cmb_post = new_cmb2_box( array(
		'id'            => $prefix.'page_metabox',
        'title'         => __( 'Header', 'cmb2' ),
        'object_types'  => array( 'page', ), // Post type
        'context'       => 'normal',
	) );
	$cmb_post->add_field( array(
	    'name'    => 'Header Image',
	    'desc'    => 'Upload an image or enter an URL.',
	    'id'      => $prefix . 'page_header_image',
	    'type'    => 'file',
	    // Optional:
	    'options' => array(
	        'url' => true, // Hide the text input for the url
	        // 'add_upload_file_text' => 'Add File' // Change upload button text. Default: "Add or Upload File"
	    ),
	) );
}