<?php

global $pre_text;
$pre_text = 'VG ';

// Slider
    add_shortcode('littleones_slider_header', 'littleones_slider_header_func');
    function littleones_slider_header_func($atts, $content = null){
        extract(shortcode_atts(array(
            'littleones_slider_header_group'    => '',
            'littleones_slider_header_type'     => '',
        ), $atts));
        ob_start();
        
    ?>
        <?php $littleones_slider_header_groups = vc_param_group_parse_atts($littleones_slider_header_group);

            if($littleones_slider_header_groups) { 
                if ($littleones_slider_header_type == 'type_1') { ?>
                    <div id="layerslider">
                    <?php foreach ($littleones_slider_header_groups as $key => $list_items):
                        
                         $img_url = wp_get_attachment_image_src($list_items['littleones_slider_header_img'],'');?>

                        <div class="ls-slide" data-ls="transition2d:48;timeshift:-2000;">
                            <!-- Background image -->
                            
                            <img src="<?php echo esc_url($img_url[0]) ?>" class="ls-bg"  alt="Slide background"/>
                            <!-- Text -->
                            <div class="ls-l header-text" data-ls="offsetxin:0;durationin:2000;delayin:200;easingin:easeInOutExpo;rotatexin:100;scalexin:0.8;scaleyin:0.8;transformoriginin:50% 50% -150;offsetxout:0;durationout:500;rotatexout:-20;scalexout:0.8;scaleyout:0.8;transformoriginout:50% 50% -150;">
                               <h1><?php echo esc_attr($list_items['littleones_slider_header_title']) ?></h1>
                               <p class="subtitle hidden-xs"> <?php echo esc_attr($list_items['littleones_slider_header_subtitle']) ?> </p>
                               <!-- Button -->
                               <div class="page-scroll hidden-xs">
                                  <a class="btn" href="#contact"><?php echo esc_attr($list_items['littleones_slider_header_btn']) ?></a>
                               </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                    </div>
                <?php } elseif($littleones_slider_header_type == 'type_2'){  ?>
                    <div id="services-slider" class="owl-carousel margin1 col-lg-12">
                        <?php foreach ($littleones_slider_header_groups as $key => $list_items):
                        
                                 $img_url = wp_get_attachment_image_src($list_items['littleones_slider_header_img'],'');?>

                                <div class="serviceBox <?php echo esc_attr($list_items['littleones_slider_header_bgc']) ?>">
                                     <!-- service image-->
                                     <img src="<?php echo esc_url($img_url[0]) ?>" class="img-responsive img-circle" alt=""/> 
                                     <!-- service content -->
                                     <div class="service-content text-light">
                                        <h4 class="title"><?php echo esc_attr($list_items['littleones_slider_header_title']) ?></h4>
                                        <p class="description">
                                            <?php echo esc_attr($list_items['littleones_slider_header_subtitle']) ?>
                                        </p>
                                     </div>
                                  </div>
                            <?php endforeach; ?>
                        </div>
                    <?php } } ?>
    <?php  
        return ob_get_clean();
    }



//Head Title
    add_shortcode('littleones_head_title', 'littleones_head_title_func');
    function littleones_head_title_func($atts, $content = null){
        extract(shortcode_atts(array(
            'littleones_head_title_text'    => '',
            'littleones_head_title_type'    => '',
            'littleones_head_title_text'    => '',
            'littleones_head_title_img'    => '',
            'littleones_head_title_position'    => '',
            'littleones_head_title_text_color'    => '',
            'littleones_head_title_icon_color'    => '',
        ), $atts));
        ob_start();
        
    ?> 
        <?php if ($littleones_head_title_type == "type_1") { ?>
     
            <div class="section-heading">
                <h2 class="<?php echo esc_attr($littleones_head_title_text_color); ?>"><?php echo esc_attr($littleones_head_title_text) ?></h2>
                <!-- divider -->
                <div class="hr <?php echo esc_attr($littleones_head_title_icon_color) ?>"></div>
           </div>

        <?php } elseif($littleones_head_title_type == "type_2") { 
            $logo_url = wp_get_attachment_image_src($littleones_head_title_img,''); ?>
            <div class="<?php echo esc_attr($littleones_head_title_position); ?> hidden-sm hidden-xs" data-0="opacity:1;" data-100="transform:translatey(40%);" data-center-center="transform:translatey(-60%);">
                <!-- Image -->
                <img src="<?php echo esc_url($logo_url[0]); ?>" alt="">
            </div>
            <div class="section-heading">
                <h2 class="<?php echo esc_attr($littleones_head_title_text_color); ?>"><?php echo esc_attr($littleones_head_title_text); ?></h2>
                <!-- divider -->
                <div class="hr"></div>
            </div>
        <?php } ?>
       
    <?php  

        return ob_get_clean();
    }



//Text Block
    add_shortcode('littleones_text_block', 'littleones_text_block_func');
    function littleones_text_block_func($atts, $content = null){
        extract(shortcode_atts(array(
            'littleones_text_block_type'          => '',
            'littleones_text_block_title'         => '',
            'littleones_text_block_subtitle'      => '',
            'littleones_text_block_group'         => '',
            'littleones_text_block_btn'           => '',
            'littleones_text_block_group_btn'     => '',
            'littleones_text_block_img'           => '',
            'littleones_text_block_position'      => '',
            'littleones_text_block_group_listitm' => '',
        ), $atts));
        ob_start();
        
    ?>
        
        <?php if ($littleones_text_block_type == "type_1") {
            $littleones_text_block_groups = vc_param_group_parse_atts($littleones_text_block_group);
            $img_url = wp_get_attachment_image_src($littleones_text_block_img,'');?>
            
            <div class="col-md-5">
                  <img src="<?php echo esc_url($img_url[0]); ?>" class="img-responsive img-curved center-block" alt=""/> 
               </div>
               <!-- main text -->
               <div class="col-md-12 col-md-7 res-margin">
                  <h3><?php echo esc_attr($littleones_text_block_title); ?></h3>
                  <p><?php echo esc_attr($littleones_text_block_subtitle); ?></p>
                  <!-- Custom List -->
                    <?php if($littleones_text_block_groups) { ?>
                        <ul class="custom no-margin">
                   
                            <?php foreach ($littleones_text_block_groups as $key => $list_items) { ?>
                                <li><?php echo esc_attr($list_items['littleones_text_block_group_list']) ?></li>
                            <?php }?>
                        </ul>
                    <?php } ?>
               </div>
         <?php } elseif ($littleones_text_block_type == "type_3") {
                 $littleones_text_block_group_btns = vc_param_group_parse_atts($littleones_text_block_group_btn); ?>
                <div class="text-center col-md-12">
                      <!-- well -->
                      <div class="well col-lg-5 <?php echo esc_attr($littleones_text_block_position) ?>">
                         <h4><?php echo esc_attr($littleones_text_block_title); ?></h4>
                         <p><?php echo esc_attr($littleones_text_block_subtitle); ?></p>
                         <!-- Buttons -->
                         <div class="page-scroll">
                            <?php foreach ($littleones_text_block_group_btns as $key => $list_items): ?>
                                <a class="btn <?php if($key >0) echo('margin-btn') ?>" href="<?php echo esc_attr($list_items['littleones_text_block_group_btn_link']); ?>"><?php echo esc_attr($list_items['littleones_text_block_group_btn_title']); ?></a>
                            <?php endforeach ?>
                         </div>
                      </div>
                      <!-- /well -->
                   </div>


       <?php }  elseif ($littleones_text_block_type == "type_4") { 
                $littleones_text_block_group_listitms = vc_param_group_parse_atts($littleones_text_block_group_listitm); ?>
                <div class="res-margin">
                     <div class=" col-md-offset-1 well text-center">
                        <h4><?php echo esc_attr($littleones_text_block_title); ?></h4>
                        <!-- contact info -->              
                        <div class="contact-info ">
                            <?php foreach ($littleones_text_block_group_listitms as $key => $list_items) { ?>
                           <p><i class="fa fa-<?php echo esc_attr($list_items['littleones_text_block_listitm_icon']) ?> margin-icon"></i><?php echo esc_attr($list_items['littleones_text_block_listitm_text']) ?></p>
                           <?php } ?>
                        </div>
                     </div>
                  </div>
       <?php } ?>
    <?php  

        return ob_get_clean();
    }

// Slide Team
    add_shortcode('littleones_slider_team', 'littleones_slider_team_func');
    function littleones_slider_team_func($atts, $content = null){
        extract(shortcode_atts(array(
            'littleones_slider_team_group'        => '',
        ), $atts));
        ob_start();
        
    ?>
        <?php $littleones_slider_team_groups = vc_param_group_parse_atts($littleones_slider_team_group); ?>
        <div class="container">
            <div id="team-slider" class="owl-carousel">
                 <!-- team member1 -->
                <?php foreach ($littleones_slider_team_groups as $key => $list_items) { 
                     $img_url = wp_get_attachment_image_src($list_items['littleones_slider_team_img'],''); ?>
                <div class="our-team">
                    <div class="pic">
                       <!-- picture -->
                       <img src="<?php echo esc_url($img_url[0]) ?>" class="img-responsive img-circle" alt="">
                       <!-- Social icons -->
                        <div class="social">
                          <ul class="social-icon">
                             <li><a href="#" class="fa fa-facebook"></a></li>
                             <li><a href="#" class="fa fa-google-plus"></a></li>
                             <li><a href="#" class="fa fa-twitter"></a></li>
                          </ul>
                        </div>
                       <!-- /social -->
                        <div class="team-info">
                          <h4><?php echo esc_attr($list_items['littleones_slider_team_name']) ?></h4>
                          <span class="post"><?php echo esc_attr($list_items['littleones_slider_team_job']) ?></span>
                        </div>
                       <!-- /tem-info -->
                    </div>
                    <!-- description-->
                    <p class="description"><?php echo esc_attr($list_items['littleones_slider_team_desc']) ?></p>
                </div>
                <?php } ?>
            </div>
        </div>


     <?php  

        return ob_get_clean();
    }


// Slide Lastest Post
     add_shortcode('littleones_slider_post', 'littleones_slider_post_func');
    function littleones_slider_post_func($atts, $content = null){
        extract(shortcode_atts(array(
            'littleones_slider_post_number_post'        => '',
        ), $atts));
        ob_start();
        if($littleones_slider_post_number_post != ''){
            $ppp = (int)$littleones_slider_post_number_post;
            if(is_numeric($ppp)){
                $args = array(
                    'posts_per_page' => $ppp
                );
                $the_query = new WP_Query( $args );
    ?>
    <?php 
    if($the_query->have_posts()){
    ?>
        <div id="blog-slider" class="owl-carousel">
                <?php
                    while ( $the_query->have_posts()) : $the_query->the_post();
                ?>
        
                    <div class="col-md-12">
                         <div class="blog-prev" >
                            <!-- Blog Post Image  -->
                            <?php 
                                $url_img      = get_the_post_thumbnail_url(get_the_ID(),'full');
                                if($url_img){
                                    $url_resize   = littleones_resize_thumb( $url_img, 436,244);
                            ?>
                            <img src="<?php echo esc_url($url_resize)?>" />
                            <?php } ?>
                            <!-- Blog Post date -->
                            <div class="date"><span class="day"><?php echo get_the_date( 'd' ) ?></span><span class="month"><?php echo get_the_date( 'M' )  ?></span></div>
                            <!-- Blog Caption -->
                            <div class="blog-caption">
                               <h4><?php the_title(); ?></h4>
                               <p class="hidden-xs"><?php echo littleones_excerpt(20); ?></p>
                            </div>
                            <div class="hover"></div>
                            <a href="<?php the_permalink(); ?>"></a>
                         </div>
                         <!-- /Blog Post Prev -->
                    </div>
             <?php 
                    endwhile;
                ?>
        </div>
    <?php 
        wp_reset_postdata();
    }
    ?>
    <?php  
        }}
        return ob_get_clean();
    }
//Pricing Table

    add_shortcode('littleones_pricing_table', 'littleones_pricing_table_func');
    function littleones_pricing_table_func($atts, $content = null){
        extract(shortcode_atts(array(
            'littleones_pricing_table_title'        => '',
            'littleones_pricing_table_price'       => '',
            'littleones_pricing_table_time'    => '',
            'littleones_pricing_table_group'    => '',
            'littleones_pricing_table_btn'    => '',
            'littleones_pricing_table_btn_url'    => '',
        ), $atts));
        ob_start();
        
    ?>  
            <?php 
                $littleones_pricing_table_groups = vc_param_group_parse_atts($littleones_pricing_table_group);
             ?>

             <div class="">
                 <div class="pricingTable">
                    <!-- header -->
                    <div class="pricingTable-header">
                       <span class="title"><?php echo esc_attr($littleones_pricing_table_title); ?></span>
                       <span class="price-value"><?php echo esc_attr($littleones_pricing_table_price); ?></span>
                       <span class="month"><?php echo esc_attr($littleones_pricing_table_time); ?></span>
                    </div>
                    <!-- pricing content -->
                    <ul class="pricing-content">
                       <?php foreach ($littleones_pricing_table_groups as $list_items) { ?>
                           <li><?php echo esc_attr($list_items['littleones_pricing_table_content']); ?></li>
                        <?php } ?>
                    </ul>
                    <!-- /ul -->
                    <!-- button -->
                    <a href="<?php echo esc_attr($littleones_pricing_table_btn_url); ?>" class="btn"><?php echo esc_attr($littleones_pricing_table_btn); ?></a>
                 </div>
                 <!-- /pricingTable -->
              </div>
            
    <?php  

        return ob_get_clean();
    }


//Testimonials

    add_shortcode('littleones_testimonials', 'littleones_testimonials_func');
    function littleones_testimonials_func($atts, $content = null){
        extract(shortcode_atts(array(
            'littleones_testimonials_logo'        => '',
            'littleones_testimonials_title'       => '',
            'littleones_testimonials_group'    => '',
        ), $atts));
        ob_start();
        
    ?>  
            <?php 
                $littleones_testimonials_groups = vc_param_group_parse_atts($littleones_testimonials_group);
             ?>

            <div class="container">
                <div id="testimonial-slider" class="owl-carousel ">
                  <!-- Testimonial 1 -->
                  <?php foreach ($littleones_testimonials_groups as $list_items) {
                        $img_url = wp_get_attachment_image_src($list_items['littleones_testimonials_author_img'],'');?>
                    <div class="testimonial">
                        <div class="description">
                            <p><?php echo esc_attr($list_items['littleones_testimonials_testimonial']); ?></p>
                        </div>
                        <div class="testimonial-review">
                            <!-- Testimonial image -->
                            <img src="<?php echo esc_url($img_url[0]) ?>" class="img-circle" alt=""/>
                            <!-- Testimonial title-->
                            <h3 class="testimonial-title">
                               <?php echo esc_attr($list_items['littleones_testimonials_author']) ?>
                               <small><?php echo esc_attr($list_items['littleones_testimonials_author_job']) ?></small>
                            </h3>
                        </div>
                    </div>
                    <?php } ?>
                </div>
            </div>
            
    <?php  

        return ob_get_clean();
    }
//  Navigation Tab Button

    add_shortcode('littleones_navigation_tab', 'littleones_navigation_tab_func');
    function littleones_navigation_tab_func($atts, $content = null){
        extract(shortcode_atts(array(
            'littleones_navigation_tab_group'        => '',
            
        ), $atts));
        ob_start();
        
    ?>  
            <?php 
                $littleones_navigation_tab_groups = vc_param_group_parse_atts($littleones_navigation_tab_group);
            ?>
            <div class="text-center">
                <ul class="nav nav-pills category text-center" role="tablist" id="gallerytab">
                    <?php foreach ($littleones_navigation_tab_groups as $key => $list_items) { ?>
                     <li class="<?php if($key == 0){?> active <?php } ?>"><a href="#" data-toggle="tab" data-filter="<?php echo esc_attr($list_items['littleones_navigation_filter']) ?>"><?php echo esc_attr($list_items['littleones_navigation_tab_title']) ?></a></li>
                    <?php } ?>
                </ul>
            </div>
            
    <?php  

        return ob_get_clean();
    }


//  Navigation Tab Content

    add_shortcode('littleones_navigation_tab_content', 'littleones_navigation_tab_content_func');
    function littleones_navigation_tab_content_func($atts, $content = null){
        extract(shortcode_atts(array(
            'littleones_navigation_tab_content_group'        => '',
        ), $atts));
        ob_start();
        
    ?>  
            <?php 
                $littleones_navigation_tab_content_groups = vc_param_group_parse_atts($littleones_navigation_tab_content_group);
            ?>
           
    <div class="polaroids margin1">
        <div id="lightbox">
         <!-- image1 -->
            <?php foreach ($littleones_navigation_tab_content_groups as $list_items) { 
                $img_url = wp_get_attachment_image_src($list_items['littleones_navigation_tab_content_img'],''); ?>
                <div class="<?php echo esc_attr($list_items['littleones_navigation_tab_content_category']) ?> col-lg-3 col-md-6 col-sm-6">
                    <div class="polaroid-item">
                        <a href="<?php echo esc_url($img_url[0]) ?>" data-gal="prettyPhoto[gallery]">
                            <img alt="" src="<?php echo esc_url($img_url[0]) ?>" class="img-responsive"/>
                            <p><?php echo esc_attr($list_items['littleones_navigation_tab_content_title']) ?></p>
                        </a>
                    </div>
                </div>
            <?php } ?>
        </div>
    </div>
            
    <?php  

        return ob_get_clean();
    }

//  About us tab

    add_shortcode('littleones_about_us_tab', 'littleones_about_us_tab_func');
    function littleones_about_us_tab_func($atts, $content = null){
        extract(shortcode_atts(array(
            'littleones_about_us_tab_group_tab' => '',
        ), $atts));
        ob_start();
        $littleones_about_us_tab_group_tabs = vc_param_group_parse_atts($littleones_about_us_tab_group_tab);
    ?>  
<?php if($littleones_about_us_tab_group_tabs){ ?>
<div class="tab" role="tabpanel">
    <!-- Nav tabs -->
    <ul class="nav nav-tabs" role="tablist">
        <?php foreach ($littleones_about_us_tab_group_tabs as $key => $littleones_about_us_tab_group_tab) { ?>
            <li role="presentation" <?php if($key==0) echo 'class="active"' ?> ><a href="#Section<?php echo esc_attr($key+1); ?>" role="tab" data-toggle="tab"><?php echo esc_html($littleones_about_us_tab_group_tab['littleones_about_us_tab_group_tab_tab_name']) ?></a></li>
        <?php } ?>
    </ul>
    <div class="tab-content">
        <?php foreach ($littleones_about_us_tab_group_tabs as $key => $littleones_about_us_tab_group_tab) { ?>
        <?php $img_url = wp_get_attachment_image_src($littleones_about_us_tab_group_tab['littleones_about_us_tab_group_tab_image_content'],''); ?>
        <div role="tabpanel" class="tab-pane <?php if($key==0) echo 'active in'; ?>  fade col-lg-12" id="Section<?php echo esc_attr($key+1); ?>">
            <?php if($littleones_about_us_tab_group_tab['littleones_about_us_tab_group_tab_tab_type'] == '' || $littleones_about_us_tab_group_tab['littleones_about_us_tab_group_tab_tab_type'] == 'type_1'){ ?>
                <div class="col-lg-7">
                    <h3 class="text-center"><?php echo esc_html($littleones_about_us_tab_group_tab['littleones_about_us_tab_group_tab_title_content']); ?></h3>
                    <?php echo htmlspecialchars_decode(esc_html($littleones_about_us_tab_group_tab['littleones_about_us_tab_group_tab_normal_content'])); ?>
                </div>
                <div class="col-lg-5">
                    
                    <img src="<?php echo esc_url($img_url[0]) ?>" alt="" class="img-curved  center-block img-responsive" />
                </div>
            <?php } else if($littleones_about_us_tab_group_tab['littleones_about_us_tab_group_tab_tab_type'] == 'type_3'){ ?>
                <h3 class="text-center"><?php echo esc_html($littleones_about_us_tab_group_tab['littleones_about_us_tab_group_tab_title_content']); ?></h3>
                <div class="col-lg-5 margin1">
                    <img src="<?php echo esc_url($img_url[0]) ?>" alt="" class="img-curved center-block img-responsive" />
                </div>
                <?php $littleones_about_us_tab_group_tab_tab_items = vc_param_group_parse_atts($littleones_about_us_tab_group_tab['littleones_about_us_tab_group_tab_tab_item']); ?>
                <div class="panel-group col-lg-7 margin1" id="accordion">
                    <!-- Question 1 -->
                    <?php foreach ($littleones_about_us_tab_group_tab_tab_items as $key => $littleones_about_us_tab_group_tab_tab_item) { ?>
                    <div class="panel">
                        <div class="panel-heading">
                            <h6 class="panel-title">
                             <a class="accordion-toggle <?php if($key != 0) echo 'collapsed' ?>" data-toggle="collapse" data-parent="#accordion" href="#collapse<?php echo esc_attr($key+1); ?>"><?php echo esc_html($littleones_about_us_tab_group_tab_tab_item['littleones_about_us_tab_group_tab_tab_item_title']) ?></a>
                            </h6>
                        </div>
                        <!-- /panel-heading -->
                        <div id="collapse<?php echo esc_attr($key+1); ?>" class="panel-collapse collapse <?php if($key == 0) echo 'in' ?>">
                            <div class="panel-body">
                                <p><?php echo htmlspecialchars_decode(esc_html($littleones_about_us_tab_group_tab_tab_item['littleones_about_us_tab_group_tab_tab_item_content'])) ?></p>
                            </div>
                        </div>
                    </div>
                    <?php } ?>
                </div>
            <?php } else { ?>
            <?php $littleones_about_us_tab_group_tab_tab_items = vc_param_group_parse_atts($littleones_about_us_tab_group_tab['littleones_about_us_tab_group_tab_tab_item']); ?>
                <div class="panel-group col-lg-7 margin1" id="accordion2">
                    <h3 class="text-center"><?php echo esc_html($littleones_about_us_tab_group_tab['littleones_about_us_tab_group_tab_title_content']); ?></h3>
                    <!-- Question 1 -->
                    <?php foreach ($littleones_about_us_tab_group_tab_tab_items as $key => $littleones_about_us_tab_group_tab_tab_item) { ?>
                    <div class="panel">
                        <div class="panel-heading">
                            <h6 class="panel-title">
                                <a class="accordion-toggle <?php if($key != 0) echo 'collapsed' ?>" data-toggle="collapse" data-parent="#accordion2" href="#collapse2<?php echo esc_attr($key+1); ?>"><?php echo esc_html($littleones_about_us_tab_group_tab_tab_item['littleones_about_us_tab_group_tab_tab_item_title']) ?></a>
                            </h6>
                        </div>
                         <!-- /panel-heading -->
                         <div id="collapse2<?php echo esc_attr($key+1); ?>" class="panel-collapse collapse <?php if($key == 0) echo 'in' ?>">
                            <div class="panel-body">
                                <?php echo htmlspecialchars_decode(esc_html($littleones_about_us_tab_group_tab_tab_item['littleones_about_us_tab_group_tab_tab_item_content'])) ?>
                            </div>
                        </div>
                    </div>
                    <?php } ?>

                </div>
                <div class="col-lg-5 margin1">
                  <img src="<?php echo esc_url($img_url[0]) ?>" alt="" class="img-curved center-block img-responsive"/>
                </div>
            <!--/panel -->
            <?php } ?>
            <?php 
            $littleones_about_us_tab_group_tab_addition_items = vc_param_group_parse_atts($littleones_about_us_tab_group_tab['littleones_about_us_tab_group_tab_addition_item']);
            if(isset($littleones_about_us_tab_group_tab['littleones_about_us_tab_group_tab_addition_content']) && $littleones_about_us_tab_group_tab['littleones_about_us_tab_group_tab_addition_content'] == 'type_1' && $littleones_about_us_tab_group_tab_addition_items){ ?>
            <div class="features col-lg-12 margin1">
                <!-- First Collumn -->
                <div id="featured-icons" class="well owl-carousel margin1">
                    <!-- item1 -->
                    <?php foreach ($littleones_about_us_tab_group_tab_addition_items as $key => $littleones_about_us_tab_group_tab_addition_item) { ?>
                       <div class="media text-center">
                            <i class="<?php echo esc_attr($littleones_about_us_tab_group_tab_addition_item['littleones_about_us_tab_group_tab_addition_item_icon']) ?>"></i>
                            <div class="media-body">
                                <h5 class="media-heading"><?php echo esc_attr($littleones_about_us_tab_group_tab_addition_item['littleones_about_us_tab_group_tab_addition_item_title']) ?></h5>
                                <p><?php echo esc_attr($littleones_about_us_tab_group_tab_addition_item['littleones_about_us_tab_group_tab_addition_item_content']) ?></p>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            </div>
            <?php } ?>
            <!-- /row features -->
        </div>
        <?php } ?>
        
    </div>
</div>
<?php } ?>
    <?php  

        return ob_get_clean();
    }


//  Map

    add_shortcode('littleones_map', 'littleones_map_func');
    function littleones_map_func($atts, $content = null){
        extract(shortcode_atts(array(
            'littleones_map_lat'         => '',
            'littleones_map_long'        => '',
            'littleones_map_icon'        => '',
        ), $atts));
        ob_start();
        
    ?>  
    
        <input type="hidden" name="" class="map_lat" value="<?php echo esc_attr($littleones_map_lat) ?>"> 
        <input type="hidden" name="" class="map_long" value="<?php echo esc_attr($littleones_map_long) ?>"> 
       
       <div id="map-canvas"></div>
       <script>
           <?php $url_images = wp_get_attachment_image_src($littleones_map_icon,'');
           ?> 
            var link_marker = '<?php echo esc_url($url_images[0]); ?>';
            
       </script>
   
            
    <?php  

        return ob_get_clean();
    }

    add_shortcode('littleones_newsletter_sc', 'littleones_newsletter_sc_func');
    function littleones_newsletter_sc_func($atts, $content = null){
        extract(shortcode_atts(array(
            'littleones_newsletter_sc_form_num'         => '',
        ), $atts));
        ob_start();
        
        if($littleones_newsletter_sc_form_num != '') {
            $num_form = (int)$littleones_newsletter_sc_form_num;
            if(is_numeric($num_form)){
                 echo do_shortcode('[newsletter_form form="'.$num_form.'"]');
            }
        }
        

        return ob_get_clean();
    }
?>