<?php 

    // Get header layout
    get_header();
    // Define variable
    $littleones_theme_option = get_option('theme_option');
?>
    
    <!-- Error 404 Start 
    ====================================================== -->
    <section class="error-page-sec">
        <div class="error-page-bg lmt40">
            <div class="overlay-mask">
                <div class="container">
                    <div class="error-404-contents">
                        <h1 class="text-center">
                            <?php 
                                if (isset($littleones_theme_option['littleones_text-header']) && !empty($littleones_theme_option['littleones_text-header'])) {
                                    echo esc_attr($littleones_theme_option['littleones_text-header']);
                                } else {
                                    echo esc_html__('404', 'littleones');
                                }
                            ?>
                        </h1>
                        <h3 class="text-center">
                            <?php 
                                if (isset($littleones_theme_option['littleones_text-message-error']) && !empty($littleones_theme_option['littleones_text-message-error'])) {
                                    echo esc_attr($littleones_theme_option['littleones_text-message-error']);
                                } else {
                                    echo esc_html__('This page not found...!', 'littleones');
                                }
                            ?>
                        </h3>
                        <a class="text-center" href="<?php echo esc_url( home_url( '/' ) ); ?>"><h5><i class="fa fa-home" aria-hidden="true"></i>
                            
                            <?php 
                                if (isset($littleones_theme_option['littleones_text-backhome']) && !empty($littleones_theme_option['littleones_text-backhome'])) {
                                    echo esc_attr($littleones_theme_option['littleones_text-backhome']);
                                } else {
                                    echo esc_html__('Back to home', 'littleones');                                    
                                }
                            ?>
                            </h5>
                        </a>
                    </div>
                    
                        
                </div>
            </div>  
        </div>
        
    </section>
    <!-- =================================================
    Error 404 Area End -->

<?php 
    // Get footer layout
    get_footer('404');
?>