<?php 
    // Get header layout
    get_header();
    // Define variable
    $littleones_theme_option = get_option('theme_option');
?>

  <!-- Blog Page -->
<div id="page-section">
   <section id="blog">
      <div class="container-fluid">
        <?php $class_extend_heading='no-img-heading'; if(isset($littleones_theme_option['littleones_page_option_general_option_img_bg']) && !empty($littleones_theme_option['littleones_page_option_general_option_img_bg']) && $littleones_theme_option['littleones_page_option_general_option_img_bg']['url'] != ''){ $class_extend_heading='';?>
         <div class="jumbotron"></div>
         <?php  } ?>
         <!-- /jumbotron-->
         <div class="jumbo-heading <?php echo esc_attr($class_extend_heading); ?>">
            <!-- Heading -->
            <h1>
            	<?php
                    if ( is_day() ) :
                        printf( esc_html__( 'Daily Archives: %s', 'littleones' ), get_the_date() );
                    elseif ( is_month() ) :
                        printf( esc_html__( 'Monthly Archives: %s', 'littleones' ), get_the_date( _x( 'F Y', 'monthly archives date format', 'littleones' ) ) );
                    elseif ( is_year() ) :
                        printf( esc_html__( 'Yearly Archives: %s', 'littleones' ), get_the_date( _x( 'Y', 'yearly archives date format', 'littleones' ) ) );
                    else :
                        esc_html_e( 'Archives', 'littleones' );
                    endif;
                ?>
            </h1>
            <!-- Breadcrumb -->
            <?php littleones_breadcrumbs(); ?>
         </div>
         <!-- /jumbo-heading -->
         <!-- Blog Home -->
	  <div class="container">
         <div id="blog-container" class="col-md-9">
            <?php 
            if(have_posts()):
                while (have_posts() ) : the_post();
                	$littleones_format_of_post = get_post_format();
                    if ( false === $littleones_format_of_post ) {
                        $littleones_format_of_post = 'standard';
                    }
                    if($littleones_format_of_post  == 'standard'){
                    	$littleones_class_post = 'fa-file-text';
                    } else if($littleones_format_of_post  == 'video') {
                    	$littleones_class_post = 'fa-film';
                    } else if($littleones_format_of_post  == 'image') {
                    	$littleones_class_post = 'fa-camera';
                    } else {
                    	$littleones_class_post = 'fa-file-text';
                    }
                    $littleones_url_img = get_the_post_thumbnail_url(get_the_ID(),'full');
            ?>
            <!-- Blog Post 1 -->
            <div id="post-<?php the_ID(); ?>" <?php post_class(" blog-post row "); ?>>
               <div class="img-date">
                  <!-- date and category -->
                  <?php if($littleones_url_img){ $littleones_url_resize   = littleones_resize_thumb( $littleones_url_img, 795,353);?>
                  <div class="col-md-1 text-center date-category">
                     <i class="fa <?php echo esc_attr($littleones_class_post); ?> fa-2x"></i> 
                     <p><?php echo get_the_date(get_option( 'date_format' ),get_the_ID()); ?></p>
                  </div>
                  <div class="img-blog">
                     <a href="<?php echo get_post_permalink(); ?>"> <img class="img-responsive" src="<?php echo esc_url($littleones_url_resize)?>" alt="thumb-img"></a>
                  </div>
                  <?php } ?>
               </div>
               <div class="col-md-12">
                  <!-- Post header -->
                  <h3>
                     <a href="<?php echo get_post_permalink(); ?>"><?php echo get_the_title(); ?></a>
                  </h3>
                  <div class="post-info">
                     <!-- Post Author -->
                     <p><i class="fa fa-user"></i>by <a href="<?php echo get_the_author_link(); ?>"><?php echo get_the_author(); ?></a></p>
                     <!-- Post Comments -->
                     <p><i class="fa fa-comment"></i><a href="#"><?php $littleones_count_comment = get_comments_number(); echo is_numeric($littleones_count_comment) ? $littleones_count_comment:0;echo (is_numeric($littleones_count_comment)&&$littleones_count_comment==1)?' Comment':' Comments';  ?></a></p>
                  </div>
                  <!-- Post Excerpt -->
                  	<?php 
	                    if (isset($littleones_theme_option['littleones_page_option_general_option_num_excerpt']) && !empty($littleones_theme_option['littleones_page_option_general_option_num_excerpt']) && $littleones_theme_option['littleones_page_option_general_option_num_excerpt'] != '') {
	                        $num_excerpt = $littleones_theme_option['littleones_page_option_general_option_num_excerpt'];
	                    } else {
	                        $num_excerpt = 30;
	                    }
	                ?>
                  <p><?php echo littleones_excerpt($num_excerpt) ?></p>
                  <a class="btn" href="<?php echo get_post_permalink(); ?>"><?php echo esc_html__('Read More','littleones') ?> <i class="fa fa-angle-right"></i></a>
               </div>
            </div>
            <!-- /.row -->
            <?php endwhile; 
            else:
            ?>
            <div class="col-md-12">
              <h3>
                <?php _e( 'Nothing Found!', 'littleones' ); ?>
              </h3>
            </div>
            <?php endif; ?>
            <div class="text-center col-md-12">
              <ul class="pagination">
                <?php littleones_pagination(); ?>
              </ul>
            </div>
         </div>
         <!-- /blog-container -->
         <!-- Sidebar Starts -->

         <?php if ( is_active_sidebar('sidebar-1') ) { ?>
          <div class="vg_sidebar sidebar col-md-3">
           <?php dynamic_sidebar('sidebar-1');?>
          </div>
          <?php } ?>
<!-- /sidebar ends --> 
	</div>
      <!-- /container-->
      </div>
      <!-- /container-fluid-->
   </section>
   <!--Section Blog ends -->
</div>
<!--/page-section-->
 <!-- Newsletter -->
<?php if ( shortcode_exists( 'newsletter_form' ) ) { ?>
<section id="newsletter" class="small-section bg-color1">
    <div class="container text-center text-light">
        <div class="col-md-6">
          <h4><?php if (isset($littleones_theme_option['littleones_page_option_general_option_text_sub']) && !empty($littleones_theme_option['littleones_page_option_general_option_text_sub']) && $littleones_theme_option['littleones_page_option_general_option_text_sub'] != '') { echo esc_html($littleones_theme_option['littleones_page_option_general_option_text_sub']); } else { echo __('Subscribe to our Newsletter','littleones'); } ?></h4>
        </div>
        <div class="col-md-6">
          <?php 
            
            if (isset($littleones_theme_option['littleones_page_option_general_option_num_shortcode']) && !empty($littleones_theme_option['littleones_page_option_general_option_num_shortcode']) && $littleones_theme_option['littleones_page_option_general_option_num_shortcode'] != '') { $number_form_newsletter = (int)esc_html($littleones_theme_option['littleones_page_option_general_option_num_shortcode']); } else { $number_form_newsletter = 1; }
            echo do_shortcode('[newsletter_form form="'.$number_form_newsletter.'"]') ;
            
          ?>
        </div>
       <!-- /col-md-6 -->
    </div>
    <!-- /container -->
</section>
<?php } ?>

<?php 
    // Get footer layout
    get_footer();
?>