<?php
/*
 * If the current post is protected by a password and
 * the visitor has not yet entered the password we will
 * return early without loading the comments.
 */
if ( post_password_required() ) {
	return;
}
?>
<!-- LEAVE A COMMENT -->
<?php
    $aria_req = ( $req ? " aria-required='true'" : '' );
    $comment_args = array(
            'id_form'    => 'respond',                                
            'title_reply'=> '<h5>'.esc_html__('Leave a Comment:','littleones').'</h5>',
            'fields'     => apply_filters( 'comment_form_default_fields', array(
                'author' => '   <label>Name:</label>
                                <input type="text" name="author" id="author" class="form-control input-field">
                                           ',   
                'email' => '    <label>Email:</label>
                                    <input type="email" name="email" id="email" class="form-control input-field">'
            ) ),                                
            'comment_field' => '
                                <label>Comment:</label>
                                <textarea name="comment"'.$aria_req.' id="comment" class="textarea-field form-control" rows = "5" ></textarea>                                                
                                            
                                        ',                                                 
            'label_submit' => 'Post Comment',
            'class_submit' => 'btn',
            'comment_notes_before' => '',
            'comment_notes_after' => '',               
    )
?>
<div class="col-md-12">
    <div class="col-md-8 col-centered">
        <?php comment_form($comment_args); ?>
    </div>
</div>

<!-- COMMENTS -->

<?php 
	if ( have_comments() ) : 
?>
	<div class="comments-block">				
        <h4 class="text-center">Comments</h4>
        <hr>
		<?php wp_list_comments('callback=littleones_theme_comment'); ?>
		<!--End comments and replys-->
		<?php
			if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) :
		?>
			<nav class="navigation comment-navigation" role="navigation">
			   
				<div class="nav-previous"><?php previous_comments_link( esc_html__( '&larr; Older Comments', 'littleones' ) ); ?></div>
				<div class="nav-next"><?php next_comments_link( esc_html__( 'Newer Comments &rarr;', 'littleones' ) ); ?></div>
			</nav>
			<!-- .comment-navigation -->
		<?php endif; // Check for comment navigation ?>

		<?php if ( ! comments_open() && get_comments_number() ) : ?>
			<p class="no-comments"><?php esc_html_e( 'Comments are closed.' , 'littleones' ); ?></p>
		<?php endif; ?>	

    </div>
<?php endif; ?>
