<?php
// class widget
class about_widget extends WP_Widget {
        
        // declere widget
        // config: ID , Description
        function __construct() {
            $wget_options = array(
                    'classname' => 'imgdes-widget', // ID and class name of widget
                    'description' => 'Widget show about information.' // DES show in dashboard
            );
            parent::__construct('about_widget', 'About information', $wget_options);
        } 

        // Widget Backend - anything show in widget
        function form( $instance ) {
                $default = array(
                    'title'       => 'About Us',
                    'description' => '',
                    'tw_class'    => 'fa-twitter',
                    'tw_link'     => '',
                    'fb_class'    => 'fa-facebook',
                    'fb_link'     => '',
                    'li_class'    => 'fa-linkedin',
                    'li_link'     => '',
                    'pr_class'    => 'fa-pinterest',
                    'pr_link'     => '',
                    'it_class'    => 'fa-instagram',
                    'it_link'     => '',
                );
                $instance         = wp_parse_args( (array) $instance, $default );
                $title            = esc_attr($instance['title']);
                $description      = esc_attr(format_to_edit($instance['description']));
                $tw_class         = esc_attr($instance['tw_class']);
                $tw_link          = esc_attr($instance['tw_link']);
                $fb_class         = esc_attr($instance['fb_class']);
                $fb_link          = esc_attr($instance['fb_link']);
                $li_class         = esc_attr($instance['li_class']);
                $li_link          = esc_attr($instance['li_link']);
                $pr_class         = esc_attr($instance['pr_class']);
                $pr_link          = esc_attr($instance['pr_link']);
                $it_class         = esc_attr($instance['it_class']);
                $it_link          = esc_attr($instance['it_link']);

                echo '<p>Title <input type="text" class="widefat" name="'.$this->get_field_name('title').'" value="'.$title.'"/></p>';
                echo '<p>Description<textarea class="widefat" rows="16" cols="20" id="' .$this->get_field_id('description').'" name="'. $this->get_field_name('description').'">'. $description.'</textarea></p>';

                echo '<p>Twitter icon: <input type="text" class="widefat" name="'.$this->get_field_name('tw_class').'" value="'.$tw_class.'"/></p>';
                echo '<p>Twitter link: <input type="text" class="widefat" name="'.$this->get_field_name('tw_link').'" value="'.$tw_link.'"/></p>';
                echo '<p>Facebook icon: <input type="text" class="widefat" name="'.$this->get_field_name('fb_class').'" value="'.$fb_class.'"/></p>';
                echo '<p>Facebook link: <input type="text" class="widefat" name="'.$this->get_field_name('fb_link').'" value="'.$fb_link.'"/></p>';
                echo '<p>Linkedin icon: <input type="text" class="widefat" name="'.$this->get_field_name('li_class').'" value="'.$li_class.'"/></p>';
                echo '<p>Linkedin link: <input type="text" class="widefat" name="'.$this->get_field_name('li_link').'" value="'.$li_link.'"/></p>';
                echo '<p>Pinterest icon: <input type="text" class="widefat" name="'.$this->get_field_name('pr_class').'" value="'.$pr_class.'"/></p>';
                echo '<p>Pinterest link: <input type="text" class="widefat" name="'.$this->get_field_name('pr_link').'" value="'.$pr_link.'"/></p>';
                echo '<p>Instagram icon: <input type="text" class="widefat" name="'.$this->get_field_name('it_class').'" value="'.$it_class.'"/></p>';
                echo '<p>Instagram link: <input type="text" class="widefat" name="'.$this->get_field_name('it_link').'" value="'.$it_link.'"/></p>';
        }

        // Updating widget replacing old instances with new
        function update( $new_instance, $old_instance ) {
                $instance = $old_instance;
                $instance['title']       = strip_tags($new_instance['title']);
                $instance['description'] = strip_tags($new_instance['description']);
                $instance['fb_class']    = strip_tags($new_instance['fb_class']);
                $instance['fb_link']     = strip_tags($new_instance['fb_link']);
                $instance['tw_class']    = strip_tags($new_instance['tw_class']);
                $instance['tw_link']     = strip_tags($new_instance['tw_link']);
                $instance['li_class']    = strip_tags($new_instance['li_class']);
                $instance['li_link']     = strip_tags($new_instance['li_link']);
                $instance['pr_class']    = strip_tags($new_instance['pr_class']);
                $instance['pr_link']     = strip_tags($new_instance['pr_link']);
                $instance['it_class']    = strip_tags($new_instance['it_class']);
                $instance['it_link']     = strip_tags($new_instance['it_link']);
                return $instance;
        }
        
        // Creating widget front-end
        function widget( $args, $instance ) {
                extract($args);
                $title         = apply_filters( 'widget_title', $instance['title'] );
                $description   = ! empty( $instance['description'] ) ? $instance['description'] : '';
                $fb_class   = ! empty( $instance['fb_class'] ) ? $instance['fb_class'] : '';
                $fb_link    = ! empty( $instance['fb_link'] ) ? $instance['fb_link'] : '';
                $tw_class   = ! empty( $instance['tw_class'] ) ? $instance['tw_class'] : '';
                $tw_link    = ! empty( $instance['tw_link'] ) ? $instance['tw_link'] : '';
                $li_class   = ! empty( $instance['li_class'] ) ? $instance['li_class'] : '';
                $li_link    = ! empty( $instance['li_link'] ) ? $instance['li_link'] : '';
                $pr_class   = ! empty( $instance['pr_class'] ) ? $instance['pr_class'] : '';
                $pr_link    = ! empty( $instance['pr_link'] ) ? $instance['pr_link'] : '';
                $it_class   = ! empty( $instance['it_class'] ) ? $instance['it_class'] : '';
                $it_link    = ! empty( $instance['it_link'] ) ? $instance['it_link'] : '';

                echo $before_widget;
                echo $before_title.$title.$after_title;
                ?>
                <p><?php echo esc_html($description); ?></p>
                <?php if($fb_class || $fb_link || $tw_class || $tw_link || $li_class || $li_link || $pr_class || $pr_link || $it_class || $it_link) { ?>
                <div class="social-media">
                    <a href="<?php echo esc_url($tw_link); ?>"><i class="fa <?php echo esc_attr($tw_class); ?>" aria-hidden="true"></i></a>
                    <a href="<?php echo esc_url($fb_link); ?>"><i class="fa <?php echo esc_attr($fb_class); ?>" aria-hidden="true"></i></a>
                    <a href="<?php echo esc_url($li_link); ?>"><i class="fa <?php echo esc_attr($li_class); ?>" aria-hidden="true"></i></a>
                    <a href="<?php echo esc_url($pr_link); ?>"><i class="fa <?php echo esc_attr($pr_class); ?>" aria-hidden="true"></i></a>
                    <a href="<?php echo esc_url($it_link); ?>"><i class="fa <?php echo esc_attr($it_class); ?>" aria-hidden="true"></i></a>
                </div>
                <?php } ?>
                <?php
                echo $after_widget;
        }
 
}
 
add_action( 'widgets_init', 'create_image_and_description_widget' );
function create_image_and_description_widget() {
        register_widget('about_widget');
}
?>