<?php
// class widget
class littleones_recent_post extends WP_Widget {
        
        // declere widget
        // config: ID , Description
        function littleones_recent_post() {
                $wget_options = array(
                        'classname' => 'latest-widget', // ID and class name of widget
                        'description' => 'Widget show latest course.' // DES show in dashboard
                );
                parent::__construct('recent_post', 'Recent Post Image', $wget_options);
        }

        // Widget Backend - anything show in widget
        function form( $instance ) {
                $default = array(
                        'title'   => 'Recent Post Image',
                        'number'  => 2
                );
                $instance         = wp_parse_args( (array) $instance, $default );
                $title            = esc_attr($instance['title']);
                $number_course    = esc_attr($instance['number']);
                echo '<p>Title <input type="text" class="widefat" name="'.$this->get_field_name('title').'" value="'.$title.'"/></p>';
                echo '<p>Number Recent Post show <input type="text" class="widefat" name="'.$this->get_field_name('number').'" value="'.$number_course.'"/></p>';
        }

        // Updating widget replacing old instances with new
        function update( $new_instance, $old_instance ) {
                $instance = $old_instance;
                $instance['title'] = strip_tags($new_instance['title']);
                $instance['number'] = strip_tags($new_instance['number']);
                return $instance;
        }
        
        // Creating widget front-end
        function widget( $args, $instance ) {
                extract($args);
                $title         = apply_filters( 'widget_title', $instance['title'] );
                $number_course = apply_filters( 'widget_title', $instance['number'] );

                echo $before_widget;
                echo $before_title.$title.$after_title;
                $args = array(
                        'post_type'      => 'post',
                        'orderby'        => 'date',
                        'order'          => 'DESC',
                        'posts_per_page' => $number_course,
                    );
                $query = new WP_Query( $args );

                if($query->have_posts()):
                ?>
            <div class="row">
                <?php
                    while ( $query->have_posts()) : $query->the_post();
                    $image_thumbnail =  littleones_resize_thumb( wp_get_attachment_url(get_post_thumbnail_id()), 120,120);
                ?>
                    <div class="blog-latest col-xs-12">

                        <a href="<?php the_permalink(); ?>">
                            <div class="col-xs-4">
                                <img src="<?php echo esc_url($image_thumbnail);?>" class="img-circle img-responsive">
                            </div>
                            <div class="col-xs-8">
                                <span><?php the_title(); ?></span>
                                <p><?php the_time('d M Y') ?></p>
                            </div>
                        </a>
                    </div>
                    
                    <?php
                    endwhile;?>
            </div>
                <?php endif;
                echo $after_widget;
        }
 
}
 
add_action( 'widgets_init', 'littleones_create_latest_course_widget' );
function littleones_create_latest_course_widget() {
        register_widget('littleones_recent_post');
}