<?php
require_once get_template_directory() . '/framework/image_description.php';
require_once get_template_directory() . '/framework/recent_post.php';
require_once get_template_directory() . '/framework/wp_bootstrap_navwalker.php';
// Reqire File Style and JS
function littleones_load_theme_textdomain() {
load_theme_textdomain( 'littleones', get_template_directory_uri() . '/languages/' );
}
add_action( 'after_setup_theme', 'littleones_load_theme_textdomain' );
//add_filter('show_admin_bar', '__return_false');
//Theme Set up:
function littleones_theme_setup() {
    /*
     * This theme uses a custom image size for featured images, displayed on
     * "standard" posts and pages.
     */
    add_theme_support( 'custom-header' ); 
    add_theme_support( 'custom-background' );
    add_theme_support ('title-tag');
    add_theme_support( 'post-thumbnails' );
    // Adds RSS feed links to <head> for posts and comments.
    add_theme_support( 'automatic-feed-links' );
    // Switches default core markup for search form, comment form, and comments
    // to output valid HTML5.
    add_theme_support( 'html5', array( 'search-form', 'comment-form', 'comment-list', 'gallery', 'caption' ) );
    //Post formats
    add_theme_support( 'post-formats', 
    array(
        'image', 
        'video' , 
    ));
    // This theme uses wp_nav_menu() in one location.
    register_nav_menus( array(
        'primary'       => 'Primary Navigation Menu (Use For All Page)',
        'primary-index' => 'Index Page Menu',
    ) );

    add_action( 'comment_form_before', 'littleones_enqueue_comments_reply' );
}
add_action( 'after_setup_theme', 'littleones_theme_setup' );
if ( ! isset( $content_width ) ) $content_width = 900;

/*
Register Fonts
*/
function littleones_open_fonts_url() {
    $font_url = '';
    /*
    Translators: If there are characters in your language that are not supported
    by chosen font(s), translate this to 'off'. Do not translate into your own language.
     */
    if ( 'off' !== _x( 'on', 'Google font: on or off', 'littleones' ) ) {
        $font_url = add_query_arg( 'family', urlencode( 'Baloo|Lato:400,700,900' ), "//fonts.googleapis.com/css" );
    }
    return $font_url;
}


function littleones_theme_scripts_styles(){
     
    /**** Theme Specific CSS ****/
    $protocol = is_ssl() ? 'https' : 'http';
    

    wp_enqueue_style( 'littleones-style' , get_stylesheet_uri(), array(),'0.0.1'); 
    wp_enqueue_style( 'open-fonts', littleones_open_fonts_url());

    wp_enqueue_style( 'bootstrap', get_template_directory_uri() .'/css/bootstrap.css'); 
    wp_enqueue_style( 'bootstrap-glyphicons', get_template_directory_uri() .'/fonts/glyphicons/bootstrap-glyphicons.css'); 
    wp_enqueue_style( 'flaticon', get_template_directory_uri() .'/fonts/flaticons/flaticon.css');
    wp_enqueue_style( 'font-awesome-min', get_template_directory_uri() .'/fonts/font-awesome/css/font-awesome.min.css');
   
    wp_enqueue_style( 'littleones-theme-style', get_template_directory_uri() .'/css/style.css', array(), '0.0.1'); 
    wp_enqueue_style( 'littleones-plugins', get_template_directory_uri() .'/css/plugins.css');
    wp_enqueue_style( 'littleones-maincolors', get_template_directory_uri() .'/styles/maincolors.css');
    wp_enqueue_style( 'littleones-layerslider', get_template_directory_uri() .'/layerslider/css/layerslider.css');

    //ie
    wp_enqueue_script( 'littleones-html5shiv', get_template_directory_uri(). '/js/respond.js', array(), '3.7.3' );
    wp_script_add_data( 'littleones-html5shiv', 'conditional', 'lt IE 9' );
    $littleones_theme_option = get_option('theme_option');
    if (isset($littleones_theme_option['littleones_gm_api_key']) && !empty($littleones_theme_option['littleones_gm_api_key']) && $littleones_theme_option['littleones_gm_api_key'] != '') {
        $google_map_js = 'https://maps.googleapis.com/maps/api/js?key='.esc_attr($littleones_theme_option['littleones_gm_api_key']);
        wp_enqueue_script( 'littleones-map-api', $google_map_js, array(), false, true );
    }
    
    wp_enqueue_script('bootstrap',get_template_directory_uri(). '/js/bootstrap.min.js', array('jquery'),false,true);
    wp_enqueue_script('smartresize',get_template_directory_uri(). '/js/smartresize.js', array(),false,true);
    wp_enqueue_script('littleones-main',get_template_directory_uri(). '/js/main.js', array(),false,true);
    if(!is_category()){
        wp_enqueue_script('littleone-main-extend',get_template_directory_uri(). '/js/main-extend.js', array(),false,true);
    }

    wp_enqueue_script('littleone-custom',get_template_directory_uri(). '/js/custom.js', array(),false,true);
    wp_enqueue_script('littleones-contact',get_template_directory_uri(). '/js/contact.js', array(),false,true);
    wp_enqueue_script('jquery-easing',get_template_directory_uri(). '/js/jquery.easing.1.3.js', array(),false,true);
    wp_enqueue_script('owl-carousel',get_template_directory_uri(). '/js/owl.carousel.min.js', array(),false,true);
    wp_enqueue_script('jquery-prettyphoto',get_template_directory_uri(). '/js/jquery.prettyPhoto.js', array(),false,true);
    wp_enqueue_script('isotope',get_template_directory_uri(). '/js/isotope.js', array(),false,true);
    wp_enqueue_script('skrollr',get_template_directory_uri(). '/js/skrollr.min.js', array(),false,true);
    wp_enqueue_script('jquery-form',get_template_directory_uri(). '/js/jquery.form.min.js', array(),false,true);
    wp_enqueue_script('jquery-validate',get_template_directory_uri(). '/js/jquery.validate.min.js', array(),false,true);

    wp_enqueue_script('littleones-plugins',get_template_directory_uri(). '/js/plugins.js', array(),false,true);
    wp_enqueue_script('littleones-prefixfree',get_template_directory_uri(). '/js/prefixfree.js', array(),false,true);
    wp_enqueue_script( 'layerslider-kreaturamedia-jquery', get_template_directory_uri() .'/layerslider/js/layerslider.kreaturamedia.jquery.js',array(),false,true);
    $wnm_custom = array( 'stylesheet_directory_uri' => get_stylesheet_directory_uri() );
    wp_localize_script( 'layerslider-kreaturamedia-jquery', 'directory_uri', $wnm_custom );
    wp_localize_script( 'littleones-custom', 'directory_uri', $wnm_custom );
}
add_action( 'wp_enqueue_scripts', 'littleones_theme_scripts_styles' );

function littleones_custom_editor_styles() {
    add_editor_style( get_template_directory_uri().'/css/custom-editor-style.css');
}
 
add_action( 'init', 'littleones_custom_editor_styles' );

function littleones_add_styles_method() {
    $littleones_theme_option = get_option('theme_option');
    wp_enqueue_style(
        'custom-style',
        get_template_directory_uri() . '/css/custom-style.css'
    );
    $custom_css = "";

    if(is_single() ){
        global $post;
        $header_imagebg  = get_post_meta( $post->ID, 'littleones_header_image', 1 );
        if(isset($header_imagebg) && $header_imagebg != '') {
            $custom_css .= '.jumbotron { background-image: url('. esc_url($header_imagebg) .') !important; }';   
        }
    }else{
        if(is_page() ){
            global $post;
            $header_imagebg  =  get_post_meta( $post->ID, 'littleones_page_header_image', true );
            if(isset($header_imagebg) && $header_imagebg != '') {
                $custom_css .= '.jumbotron { background-image: url('. esc_url($header_imagebg) .') !important; }';   
            }
        }
        if(isset($littleones_theme_option['littleones_page_option_general_option_img_bg']) && !empty($littleones_theme_option['littleones_page_option_general_option_img_bg']) && $littleones_theme_option['littleones_page_option_general_option_img_bg']['url'] != ''){
             $custom_css .= '.jumbotron { background-image: url('. esc_url($littleones_theme_option['littleones_page_option_general_option_img_bg']['url']) .') !important; }';   
        }
    }
    
    wp_add_inline_style( 'custom-style', $custom_css );
}
add_action( 'wp_enqueue_scripts', 'littleones_add_styles_method' );

// Comment Form
function littleones_theme_comment($comment, $args, $depth) {
    global $textdoimain;
    $GLOBALS['comment'] = $comment; ?>
        <div class="comment media">
            <a href="<?php the_author_link(); ?>">
            <?php echo get_avatar($comment,$size='120',$default='http://0.gravatar.com/avatar/ad516503a11cd5ca435acc9bb6523536?s=120',null,array('class' => 'media-object img-responsive img-circle') )?>
            </a>
            <div class="media-body">
                <a href="#">
                    <h6 class="media-heading"><?php comment_author(); ?>
                    <small><?php echo get_comment_date("F d, Y \\A\\T g:i a"); ?></small></h6>
                </a>
                <?php 
                    if ($comment->comment_approved == '0') :
                ?>
                <p><?php esc_html_e('Your comment is awaiting moderation.', 'littleones') ?></p>
                <?php 
                    else:
                ?>
                <?php comment_text() ?>
                <?php 
                    endif;
                ?>
                <?php comment_reply_link(array_merge( $args, array('depth' => $depth, 'max_depth' => $args['max_depth'], 'before' => '<span class="btn text-right in_a">', 'after' => '</span>'))) ?>
            </div>
        </div>

<?php
}

function littleones_move_comment_field_to_bottom( $fields ) {
    $comment_field = $fields['comment'];
    unset( $fields['comment'] );
    $fields['comment'] = $comment_field;

    return $fields;
}
add_filter( 'comment_form_fields', 'littleones_move_comment_field_to_bottom' );

// Fuction register widgets
function littleones_widgets_init() {
    global $textdoimain;
    // sidebar in single blog
    register_sidebar( array(
        'name'          => esc_html__( 'Primary Sidebar', 'littleones' ),
        'id'            => 'sidebar-1',
        'class'         => 'widget',
        'description'   => esc_html__( 'Main sidebar that appears on the single blog.', 'littleones' ),
        'before_widget' => '<div class="well widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h4 class="sidebar-header">',
        'after_title'   => '</h4>',
    ) );
    register_sidebar( array(
        'name'          => esc_html__( 'footer 1', 'littleones' ),
        'id'            => 'footer',
        'class'         => 'widget',
        'description'   => esc_html__( 'footer', 'littleones' ),
        'before_widget' => '<div class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h6>',
        'after_title'   => '</h6>',
    ) );
    
    
}
add_action( 'widgets_init', 'littleones_widgets_init' );


function littleones_search_form( $form ) {
    $form = '<form method="get" id="site-searchform" action="' . esc_url(home_url( '/' )) . '" role="search" class="input-group">
                <input type="text" id="s" name="s" value="' . get_search_query() . '" class="form-control input-lg">
                <span class="input-group-btn">
                   <button type="submit" class="btn"><i class="fa fa-search"></i></button>
               </span>
            </form>';
    return $form;
}

add_filter( 'get_search_form', 'littleones_search_form' );

function littleones_recent_posts_form( $form ) {
    $form = '<form method="get" id="site-searchform" action="' . esc_url(home_url( '/' )) . '" role="search" class="input-group">
                <input type="text" id="s" name="s" value="' . get_search_query() . '" class="form-control input-lg">
                <span class="input-group-btn">
                   <button type="submit" class="btn"><i class="fa fa-search"></i></button>
               </span>
            </form>';
    return $form;
}

add_filter( 'get_recent_posts_form', 'littleones_recent_posts_form' );

function littleones_breadcrumbs() {
       // / === OPTIONS === /
    $text['home']     = 'Home'; // text for the 'Home' link
    $text['category'] = 'Archive by Category "%s"'; // text for a category page
    $text['tax']      = 'Archive for "%s"'; // text for a taxonomy page
    $text['search']   = 'Search Results for "%s" Query'; // text for a search results page
    $text['tag']      = 'Posts Tagged "%s"'; // text for a tag page
    $text['author']   = 'Articles Posted by %s'; // text for an author page
    $text['404']      = 'Error 404'; // text for the 404 page
 
    $showCurrent = 1; // 1 - show current post/page title in breadcrumbs, 0 - don't show
    $showOnHome  = 1; // 1 - show breadcrumbs on the homepage, 0 - don't show
    $delimiter   = ''; // delimiter between crumbs
    $before      = '<li class="active">'; // tag before the current crumb
    $after       = '</li>'; // tag after the current crumb
    // / === END OF OPTIONS === /
 
    global $post;
    $homeLink = esc_url(home_url()) . '/';
    $linkBefore = '<li>';
    $linkAfter = '</li>';
    $linkAttr = ' rel="v:url" property="v:title"';
    $link = $linkBefore . '<a' . $linkAttr . ' href="%1$s">%2$s</a>' . $linkAfter;
 
    if (is_home() || is_front_page()) { 
 
        if ($showOnHome == 1) echo '<ul class="breadcrumb"><li><a href="' . $homeLink . '" class="pathway">' . $text['home'] . '</a></li></ul>';
 
    } else {
 
        echo '<ul class="breadcrumb">' . sprintf($link, $homeLink, $text['home']) . $delimiter;
 
        
        if ( is_category() ) {
            $thisCat = get_category(get_query_var('cat'), false);
            if ($thisCat->parent != 0) {
                $cats = get_category_parents($thisCat->parent, TRUE, $delimiter);
                $cats = str_replace('<a', $linkBefore . '<a' . $linkAttr, $cats);
                $cats = str_replace('</a>', '</a>' . $linkAfter, $cats);
                echo $cats;
            }
            echo $before . sprintf($text['category'], single_cat_title('', false)) . $after;
 
        } elseif( is_tax() ){
            $thisCat = get_category(get_query_var('cat'), false);
            if ($thisCat->parent != 0) {
                $cats = get_category_parents($thisCat->parent, TRUE, $delimiter);
                $cats = str_replace('<a', $linkBefore . '<a' . $linkAttr, $cats);
                $cats = str_replace('</a>', '</a>' . $linkAfter, $cats);
                echo $cats;
            }
            echo $before . sprintf($text['tax'], single_cat_title('', false)) . $after;
        
        }elseif ( is_search() ) {
            echo $before . sprintf($text['search'], get_search_query()) . $after;
 
        } elseif ( is_day() ) {
            echo sprintf($link, get_year_link(get_the_time('Y')), get_the_time('Y')) . $delimiter;
            echo sprintf($link, get_month_link(get_the_time('Y'),get_the_time('m')), get_the_time('F')) . $delimiter;
            echo $before . get_the_time('d') . $after;
 
        } elseif ( is_month() ) {
            echo sprintf($link, get_year_link(get_the_time('Y')), get_the_time('Y')) . $delimiter;
            echo $before . get_the_time('F') . $after;
 
        } elseif ( is_year() ) {
            echo $before . get_the_time('Y') . $after;
 
        } elseif ( is_single() && !is_attachment() ) {
            if ( get_post_type() != 'post' ) {
                $post_type = get_post_type_object(get_post_type());
                $slug = $post_type->rewrite;
                printf($link, $homeLink . '/' . $slug['slug'] . '/', $post_type->labels->singular_name);
                if ($showCurrent == 1) echo $delimiter . $before . get_the_title() . $after;
            } else {
                $cat = get_the_category(); $cat = $cat[0];
                $cats = get_category_parents($cat, TRUE, $delimiter);
                if ($showCurrent == 0) $cats = preg_replace("#^(.+)$delimiter$#", "$1", $cats);
                $cats = str_replace('<a', $linkBefore . '<a' . $linkAttr, $cats);
                $cats = str_replace('</a>', '</a>' . $linkAfter, $cats);
                echo $cats;
                if ($showCurrent == 1) echo $before . get_the_title() . $after;
            }
 
        } elseif ( !is_single() && !is_page() && get_post_type() != 'post' && !is_404() ) {
            $post_type = get_post_type_object(get_post_type());
            echo $before . $post_type->labels->singular_name . $after;
 
        } elseif ( is_attachment() ) {
            $parent = get_post($post->post_parent);
            $cat = get_the_category($parent->ID); $cat = $cat[0];
            $cats = get_category_parents($cat, TRUE, $delimiter);
            $cats = str_replace('<a', $linkBefore . '<a' . $linkAttr, $cats);
            $cats = str_replace('</a>', '</a>' . $linkAfter, $cats);
            echo $cats;
            printf($link, get_permalink($parent), $parent->post_title);
            if ($showCurrent == 1) echo $delimiter . $before . get_the_title() . $after;
 
        } elseif ( is_page() && !$post->post_parent ) {
            if ($showCurrent == 1) echo $before . get_the_title() . $after;
 
        } elseif ( is_page() && $post->post_parent ) {
            $parent_id  = $post->post_parent;
            $breadcrumbs = array();
            while ($parent_id) {
                $page = get_page($parent_id);
                $breadcrumbs[] = sprintf($link, get_permalink($page->ID), get_the_title($page->ID));
                $parent_id  = $page->post_parent;
            }
            $breadcrumbs = array_reverse($breadcrumbs);
            for ($i = 0; $i < count($breadcrumbs); $i++) {
                echo $breadcrumbs[$i];
                if ($i != count($breadcrumbs)-1) echo $delimiter;
            }
            if ($showCurrent == 1) echo $delimiter . $before . get_the_title() . $after;
 
        } elseif ( is_tag() ) {
            echo $before . sprintf($text['tag'], single_tag_title('', false)) . $after;
 
        } elseif ( is_author() ) {
             global $author;
            $userdata = get_userdata($author);
            echo $before . sprintf($text['author'], $userdata->display_name) . $after;
 
        } elseif ( is_404() ) {
            echo $before . $text['404'] . $after;
        }
 
        if ( get_query_var('paged') ) {
            if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() );
            if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) echo ')';
        }
 
        echo '</ul>';
 
    }
}

// Custom Excerpt
function littleones_excerpt($limit) {
    $excerpt = explode(' ', get_the_excerpt(), $limit);
    if (count($excerpt)>=$limit) {
        array_pop($excerpt);
        $excerpt = implode(" ",$excerpt).'.';
    } else {
        $excerpt = implode(" ",$excerpt);
    } 
    $excerpt = preg_replace('`\[[^\]]*\]`','',$excerpt);
    return $excerpt;
}


function littleones_pagination() {

    if( is_singular() )
        return;

    global $wp_query;

    /** Stop execution if there's only 1 page */
    if( $wp_query->max_num_pages <= 1 )
        return;

    $paged = get_query_var( 'paged' ) ? absint( get_query_var( 'paged' ) ) : 1;
    $max   = intval( $wp_query->max_num_pages );

    /** Add current page to the array */
    if ( $paged >= 1 )
        $links[] = $paged;

    if ( $paged == 1 && $max > 2 )
         $links[] = $paged + 2 ;
    /** Add the pages around the current page to the array */
    if ( $paged >= 2 ) {
        $links[] = $paged - 1;
        // $links[] = $paged - 2;
    }

    if ( ( $paged + 1 ) <= $max ) {
        // $links[] = $paged + 2;
        $links[] = $paged + 1;
    }
    if ( $paged == $max && $max > 2 )
        $links[] = $paged - 2 ;

    /** Previous Post Link */
    $url_template = get_template_directory_uri();
    if ( get_previous_posts_link() )
        printf( '<li>%s</li>' . "\n", get_previous_posts_link('&laquo;') );

    /** Link to current page, plus 2 pages in either direction if necessary */
    sort( $links );
    foreach ( (array) $links as $link ) {
        $class = $paged == $link ? 'class="active"' : '';
        printf( '<li><a %s href="%s">%s</a></li>' . "\n", $class, esc_url( get_pagenum_link( $link ) ), $link );
    }

    /** Next Post Link */
    if ( get_next_posts_link() )
        printf( '<li>%s</li>' . "\n", get_next_posts_link('&raquo;') );


}

/* Visual Composer */
//if(class_exists('WPBakeryVisualComposerSetup')){
function coursat_custom_css_classes_for_vc_row_and_vc_column($class_string, $tag) {
    if($tag=='vc_row' || $tag=='vc_row_inner') {
        $class_string = str_replace('vc_row-fluid', '', $class_string);
    }
    return $class_string;
}
// Filter to Replace default css class for vc_row shortcode and vc_column
add_filter('vc_shortcodes_css_class', 'coursat_custom_css_classes_for_vc_row_and_vc_column', 10, 2); 

if(function_exists('vc_add_param')){

  vc_add_param('vc_row',array(
          "type" => "textfield",
          "heading" => esc_html__('Section HTML', 'littleones'),
          "param_name" => "el_html",
          "value" => "",
          "description" => esc_html__("Set HTML section", 'littleones'),   
    ));   
  vc_add_param('vc_row',array(
        "type" => "dropdown",
        "heading" => esc_html__('Fullwidth', 'littleones'),
        "param_name" => "fullwidth",
        "value" => array(   
                esc_html__('No', 'littleones') => 'no',  
                esc_html__('Yes', 'littleones') => 'yes',                                                                                
                ),
        "description" => esc_html__("Select Fullwidth or not", 'littleones'),      
      ) 
    );
  vc_add_param('vc_row',array(
        "type" => "dropdown",
        "heading" => esc_html__('Show or not Show Div Overlay', 'littleones'),
        "param_name" => "overlay_div",
        "value" => array(   
                esc_html__('Not Show', 'littleones') => 'no',  
                esc_html__('Show', 'littleones') => 'yes',                                                                                
                ),
        "description" => esc_html__("Select Show Div Overlay or not", 'littleones'),      
      ) 
    );
  vc_add_param('vc_row',array(
        "type" => "attach_image",
        "heading" => esc_html__('Background Image', 'littleones'),
        "param_name" => "bg_image_custom",
        "description" => esc_html__("Select Fullwidth or not", 'littleones'),      
      ) 
    );
}




/**
 * This file represents an example of the code that themes would use to register
 * the required plugins.
 *
 * It is expected that theme authors would copy and paste this code into their
 * functions.php file, and amend to suit.
 *
 * @package    TGM-Plugin-Activation
 * @subpackage Example
 * @version    2.4.0
 * @author     Thomas Griffin <thomasgriffinmedia.com>
 * @author     Gary Jones <gamajo.com>
 * @copyright  Copyright (c) 2014, Thomas Griffin
 * @license    http://opensource.org/licenses/gpl-2.0.php GPL v2 or later
 * @link       https://github.com/thomasgriffin/TGM-Plugin-Activation
 */
/**
 * Include the TGM_Plugin_Activation class.
 */
require_once get_template_directory() . '/framework/class-tgm-plugin-activation.php';
add_action( 'tgmpa_register', 'littleones_theme_register_required_plugins' );
/**
 * Register the required plugins for this theme.
 *
 * In this example, we register two plugins - one included with the TGMPA library
 * and one from the .org repo.
 *
 * The variable passed to tgmpa_register_plugins() should be an array of plugin
 * arrays.
 *
 * This function is hooked into tgmpa_init, which is fired within the
 * TGM_Plugin_Activation class constructor.
 */
 
 
function littleones_theme_register_required_plugins() {
    /**
     * Array of plugin arrays. Required keys are name and slug.
     * If the source is NOT from the .org repo, then source is also required.
     */
    $plugins = array(   
        // This is an example of how to include a plugin from the WordPress Plugin Repository.
        array(            
            'name'     => esc_html__('WPBakery Visual Composer', 'littleones'), // The plugin name.
            'slug'     => 'js_composer', // The plugin slug (typically the folder name).
            'source'   => get_template_directory() . '/framework/plugins/js_composer.zip', // The plugin source.
            'required' => true, // If false, the plugin is only 'recommended' instead of required.
        ),

        array(
            'name'     => esc_html__('theme Common', 'littleones'), // The plugin name.
            'slug'     => 'theme-common', // The plugin slug (typically the folder name).
            'source'   => get_template_directory() . '/framework/plugins/theme-common.zip', // The plugin source.
            'required' => true, // If false, the plugin is only 'recommended' instead of required.
        ),

        array(
            'name'      => esc_html__('Newsletter', 'littleones'),
            'slug'      => 'newsletter',
            'required'  => true,
        ),

        array(
            'name'      => esc_html__('Contact Form 7', 'littleones'),
            'slug'      => 'contact-form-7',
            'required'  => true,
        ),
        array(
            'name'      => esc_html__('One Click Demo Import', 'littleones'),
            'slug'      => 'one-click-demo-import',
            'required'  => true,
        ),
    );
    /**
     * Array of configuration settings. Amend each line as needed.
     * If you want the default strings to be available under your own theme domain,
     * leave the strings uncommented.
     * Some of the strings are added into a sprintf, so see the comments at the
     * end of each line for what each argument will be.
     */
    $config = array(
        'default_path' => '',                      // Default absolute path to pre-packaged plugins.
        'menu'         => 'tgmpa-install-plugins', // Menu slug.
        'has_notices'  => true,                    // Show admin notices or not.
        'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
        'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
        'is_automatic' => false,                   // Automatically activate plugins after installation or not.
        'message'      => '',                      // Message to output right before the plugins table.
        'strings'      => array(
            'page_title'                      => esc_html__( 'Install Required Plugins', 'tgmpa' ),
            'menu_title'                      => esc_html__( 'Install Plugins', 'tgmpa' ),
            'installing'                      => esc_html__( 'Installing Plugin: %s', 'tgmpa' ), // %s = plugin name.
            'oops'                            => esc_html__( 'Something went wrong with the plugin API.', 'tgmpa' ),
            'notice_can_install_required'     => _n_noop( 'This theme requires the following plugin: %1$s.', 'This theme requires the following plugins: %1$s.', 'tgmpa' ), // %1$s = plugin name(s).
            'notice_can_install_recommended'  => _n_noop( 'This theme recommends the following plugin: %1$s.', 'This theme recommends the following plugins: %1$s.', 'tgmpa' ), // %1$s = plugin name(s).
            'notice_cannot_install'           => _n_noop( 'Sorry, but you do not have the correct permissions to install the %s plugin. Contact the administrator of this site for help on getting the plugin installed.', 'Sorry, but you do not have the correct permissions to install the %s plugins. Contact the administrator of this site for help on getting the plugins installed.', 'tgmpa' ), // %1$s = plugin name(s).
            'notice_can_activate_required'    => _n_noop( 'The following required plugin is currently inactive: %1$s.', 'The following required plugins are currently inactive: %1$s.', 'tgmpa' ), // %1$s = plugin name(s).
            'notice_can_activate_recommended' => _n_noop( 'The following recommended plugin is currently inactive: %1$s.', 'The following recommended plugins are currently inactive: %1$s.', 'tgmpa' ), // %1$s = plugin name(s).
            'notice_cannot_activate'          => _n_noop( 'Sorry, but you do not have the correct permissions to activate the %s plugin. Contact the administrator of this site for help on getting the plugin activated.', 'Sorry, but you do not have the correct permissions to activate the %s plugins. Contact the administrator of this site for help on getting the plugins activated.', 'tgmpa' ), // %1$s = plugin name(s).
            'notice_ask_to_update'            => _n_noop( 'The following plugin needs to be updated to its latest version to ensure maximum compatibility with this theme: %1$s.', 'The following plugins need to be updated to their latest version to ensure maximum compatibility with this theme: %1$s.', 'tgmpa' ), // %1$s = plugin name(s).
            'notice_cannot_update'            => _n_noop( 'Sorry, but you do not have the correct permissions to update the %s plugin. Contact the administrator of this site for help on getting the plugin updated.', 'Sorry, but you do not have the correct permissions to update the %s plugins. Contact the administrator of this site for help on getting the plugins updated.', 'tgmpa' ), // %1$s = plugin name(s).
            'install_link'                    => _n_noop( 'Begin installing plugin', 'Begin installing plugins', 'tgmpa' ),
            'activate_link'                   => _n_noop( 'Begin activating plugin', 'Begin activating plugins', 'tgmpa' ),
            'return'                          => esc_html__( 'Return to Required Plugins Installer', 'tgmpa' ),
            'plugin_activated'                => esc_html__( 'Plugin activated successfully.', 'tgmpa' ),
            'complete'                        => esc_html__( 'All plugins installed and activated successfully. %s', 'tgmpa' ), // %s = dashboard link.
            'nag_type'                        => 'updated' // Determines admin notice type - can only be 'updated', 'update-nag' or 'error'.
        )
    );
    tgmpa( $plugins, $config );
}

function littleones_resize_thumb($url,$width,$height){
    if(!$url) return false;

    $upload_info = wp_upload_dir();
    $upload_dir = $upload_info['basedir'];
    $upload_url = $upload_info['baseurl'];
    $theme_url = get_template_directory_uri();
    $theme_dir = get_template_directory();

    // find the path of the image. Perform 2 checks:
    // #1 check if the image is in the uploads folder
    if(strpos( $url, $upload_url ) !== false) {
        $rel_path = str_replace( $upload_url, '', $url);
        $img_path = $upload_dir . $rel_path;

    // #2 check if the image is in the current theme folder
    } else if (strpos($url, $theme_url) !== false) {
        $rel_path = str_replace( $theme_url, '', $url);
        $img_path = $theme_dir . $rel_path;
    }

    // Fail if we can't find the image in our WP local directory
    if ( empty( $img_path ) ) return $url;

    //check if img path exists, and is an image indeed
    if( !@file_exists($img_path) OR !getimagesize($img_path) ) return $url;

    // This is the filename
    $basename = basename($img_path);

    //get image info
    $info = pathinfo($img_path);
    $ext = $info['extension'];
    list($orig_w,$orig_h) = getimagesize($img_path);
    // create the suffix for the saved file
    // we can use this to check whether we need to create a new file or just use an existing one.
    $suffix = (string)filemtime($img_path) .
        (isset($width) ? str_pad((string)$width, 5, '0', STR_PAD_LEFT) : '00000') .
        (isset($height) ? str_pad((string)$height, 5, '0', STR_PAD_LEFT) : '00000');
    $suffix = littleones_convert_string($suffix, 10, 36);

    // use this to check if cropped image already exists, so we can return that instead
    $dst_rel_path = str_replace( '.'.$ext, '', basename($img_path));

    $upload_dir .= "/resize_thumb";
    $upload_url .= "/resize_thumb";
    if ( !is_dir( $upload_dir ) ) {
        wp_mkdir_p( $upload_dir );
    }

    // desination paths and urls
    $destfilename = "{$upload_dir}/{$dst_rel_path}-{$suffix}.{$ext}";
    $img_url = "{$upload_url}/{$dst_rel_path}-{$suffix}.{$ext}";

    // if file exists, just return it
    if (@file_exists($destfilename) && getimagesize($destfilename)) {
    } else {
        // perform resizing and other filters
        $editor = wp_get_image_editor($img_path);

        if (is_wp_error( $editor )) return false;
        /*
         * Perform image manipulations
         */

        if ( ( isset( $width ) && $width ) || ( isset( $height ) && $height ) ) {
            if ( is_wp_error( $editor->resize( isset( $width ) ? $width : null, isset( $height ) ? $height : null, isset( $crop ) ? $crop : false ) ) ) {
                return false;
            }
        }
        // save our new image
        $mime_type = isset( $opacity ) ? 'image/png' : null;
        $resized_file = $editor->save($destfilename, $mime_type);
    }

    $image = $img_url;
    return $image;
}

function littleones_convert_string($number, $fromBase, $toBase) {
    $digits = '0123456789abcdefghijklmnopqrstuvwxyz';
    $length = strlen($number);
    $result = '';

    $nibbles = array();
    for ($i = 0; $i < $length; ++$i) {
        $nibbles[$i] = strpos($digits, $number[$i]);
    }

    do {
        $value = 0;
        $newlen = 0;
        for ($i = 0; $i < $length; ++$i) {
            $value = $value * $fromBase + $nibbles[$i];
            if ($value >= $toBase) {
                $nibbles[$newlen++] = (int)($value / $toBase);
                $value %= $toBase;
            }
            else if ($newlen > 0) {
                $nibbles[$newlen++] = 0;
            }
        }
        $length = $newlen;
        $result = $digits[$value].$result;
    }
    while ($newlen != 0);
    return $result;
}

add_filter('image_resize_dimensions', 'littleones_resize_thumbnail_upscale', 10, 5);
if ( !function_exists( 'littleones_resize_thumbnail_upscale' ) ) {
function littleones_resize_thumbnail_upscale($payload, $orig_w, $orig_h, $dest_w, $dest_h, $crop = false) {
    $aspect_ratio = $orig_w / $orig_h;

    $new_w = $dest_w;
    $new_h = $dest_h;

    if ( !$new_w ) {
        $new_w = intval($new_h * $aspect_ratio);
    }

    if ( !$new_h ) {
        $new_h = intval($new_w / $aspect_ratio);
    }

    $size_ratio = max($new_w / $orig_w, $new_h / $orig_h);

    $crop_w = round($new_w / $size_ratio);
    $crop_h = round($new_h / $size_ratio);
    $s_x = floor( ($orig_w - $crop_w) / 2 );
    $s_y = floor( ($orig_h - $crop_h) / 2 );

    // the return array matches the parameters to imagecopyresampled()
    return array( 0, 0, (int) $s_x, (int) $s_y, (int) $new_w, (int) $new_h, (int) $crop_w, (int) $crop_h );
}
}

function littleones_enqueue_comments_reply() {
    if( get_option( 'thread_comments' ) )  {
        wp_enqueue_script( 'comment-reply' );
    }
}

function littleones_import_files() {
    return array(
        array(
            'import_file_name'           => 'Demo Import Littleones',
            'import_file_url'            => 'http://themetrademark.com/import/littleones/littleones_sample_data.xml',
            'import_widget_file_url'     => 'http://themetrademark.com/import/littleones/widgets.json',
            'import_notice'              => esc_html__( 'Import data example Littleones', 'littleones' ),
        ),
    );
}
add_filter( 'pt-ocdi/import_files', 'littleones_import_files' );



function littleones_after_import_setup() {
    // Assign menus to their locations.
    $main_menu = get_term_by( 'name', 'Primary Navigation Menu (Use For All Page)', 'primary' );

    set_theme_mod( 'nav_menu_locations', array(
            'primary' => $main_menu->term_id,
        )
    );

    // Assign front page and posts page (blog page).
    $front_page_id = get_page_by_title( 'Index' );
    $blog_page_id  = get_page_by_title( 'Blog Home' );

    update_option( 'show_on_front', 'page' );
    update_option( 'page_on_front', $front_page_id->ID );
    update_option( 'page_for_posts', $blog_page_id->ID );

}
add_action( 'pt-ocdi/after_import', 'littleones_after_import_setup' );

?>