<?php 
    $littleones_theme_option = get_option('theme_option');
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
   <head>
      <meta charset="<?php bloginfo( 'charset' ); ?>">
      <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
      <!--[if IE]>
      <meta http-equiv="X-UA-Compatible" content="IE=edge">
      <![endif]-->
      
      <!-- Favicons-->
      <?php if (function_exists('wp_site_icon')) {
          wp_site_icon();
      } else { ?>
      <?php  if (isset($littleones_theme_option['littleones_home_image_fav_7272']) && !empty($littleones_theme_option['littleones_home_image_fav_7272']) && $littleones_theme_option['littleones_home_image_fav_7272']['url'] != '') { ?>
      <link rel="apple-touch-icon" sizes="72x72" href="<?php echo esc_url($littleones_theme_option['littleones_home_image_fav_7272']['url']); ?>">
      <?php } ?>
      <?php  if (isset($littleones_theme_option['littleones_home_image_fav_114114']) && !empty($littleones_theme_option['littleones_home_image_fav_114114']) && $littleones_theme_option['littleones_home_image_fav_114114']['url'] != '') { ?>
      <link rel="apple-touch-icon" sizes="114x114" href="<?php echo esc_url($littleones_theme_option['littleones_home_image_fav_114114']['url']); ?>">
      <?php } ?>
      <?php  if (isset($littleones_theme_option['littleones_home_image_fav']) && !empty($littleones_theme_option['littleones_home_image_fav']) && $littleones_theme_option['littleones_home_image_fav']['url'] != '') { ?>
      <link rel="shortcut icon" href="<?php echo esc_url($littleones_theme_option['littleones_home_image_fav']['url']); ?>" type="x-icon">
      <?php } ?>
      <?php } ?>
      <?php wp_head(); ?>
   </head>
   <body id="page-top" data-spy="scroll" data-target=".navbar-custom" <?php body_class(); ?>>
      <!-- Preloader  --> 
      <div id="preloader">
         <div class="spinner">
            <div class="bounce1"></div>
            <div class="bounce2"></div>
            <div class="bounce3"></div>
         </div>
      </div>
      <!-- /Preloader ends --> 
      <div id="page-width">
         <!-- Navbar -->
         <nav class="navbar navbar-custom navbar-fixed-top"  id="navbar-custom">
            <div class="container">
               <!-- Logo and toggle get grouped for better mobile display -->
               <div class="navbar-header">
                  <button type="button" class="navbar-toggle" data-toggle="collapse" data-target="#navbar-brand">
                  <i class="fa fa-bars"></i>
                  </button>
                  <!-- Logo -->
                  <div class="navbar-brand page-scroll">
                     <a href="<?php echo get_home_url(); ?>">
                      <?php if (isset($littleones_theme_option['littleones_home_image_logo']) && !empty($littleones_theme_option['littleones_home_image_logo']) && $littleones_theme_option['littleones_home_image_logo']['url'] != '') { ?>
                        <img src="<?php echo esc_url($littleones_theme_option['littleones_home_image_logo']['url']); ?>" class="img-responsive" alt="logo-header">
                      <?php }else{ ?>
                      <span class="logo-text">
                      <?php echo bloginfo( 'name' ); } ?>
                      </span>
                      </a>
                  </div>
               </div>
               <!-- /.navbar-header -->
               <!-- Collect the nav links, forms, and other content for toggling -->
               <div class="collapse navbar-collapse" id="navbar-brand">
                    <?php   
                        if ( is_page_template( 'template/header_page.php' ) || is_page_template( 'template/visual_default_page.php' ) ) {
                            $primary = array(
                              'theme_location'  => 'primary-index',
                              'menu'            => '',
                              'container'       => 'ul',
                              'container_class' => 'submenu1',
                              'container_id'    => '',
                              'menu_class'      => 'nav navbar-nav page-scroll navbar-right',
                              'menu_id'         => '',
                              'echo'            => true,
                              'fallback_cb'     => 'wp_bootstrap_navwalker::fallback',
                              'walker'          => new wp_bootstrap_navwalker(),
                              'before'          => '',
                              'after'           => '',
                              'link_before'     => '',
                              'link_after'      => '',
                              'items_wrap'      => '<ul id="%1$s" class="%2$s">%3$s</ul>',
                              'depth'           => 0,
                          );
                        } else {
                            $primary = array(
                              'theme_location'  => 'primary',
                              'menu'            => '',
                              'container'       => 'ul',
                              'container_class' => 'submenu1',
                              'container_id'    => '',
                              'menu_class'      => 'nav navbar-nav page-scroll navbar-right',
                              'menu_id'         => '',
                              'echo'            => true,
                              'fallback_cb'     => 'wp_bootstrap_navwalker::fallback',
                              'walker'          => new wp_bootstrap_navwalker(),
                              'before'          => '',
                              'after'           => '',
                              'link_before'     => '',
                              'link_after'      => '',
                              'items_wrap'      => '<ul id="%1$s" class="%2$s">%3$s</ul>',
                              'depth'           => 0,
                          );
                        }
                        if ( has_nav_menu( 'primary' ) ) {
                            wp_nav_menu( $primary );
                        }  
                    ?>
               </div>
               <!-- /.navbar-collapse -->
            </div>
            <!-- /container -->
         </nav>
         <!-- /nav -->