<?php 
/*
*Template Name: Blog Page
*
*/
    // Get header layout
    get_header();
    // Define variable
    $theme_option = get_option('theme_option');
    $header_imagebg    = get_post_meta( get_the_ID(), 'littleones_page_header_image', true );
?>

  <!-- Blog Page -->
<div id="page-section">
   <section id="blog">
      <div class="container-fluid">
        <?php $class_extend_heading='no-img-heading'; if(isset($theme_option['littleones_page_option_general_option_img_bg']) && !empty($theme_option['littleones_page_option_general_option_img_bg']) && $theme_option['littleones_page_option_general_option_img_bg']['url'] != ''){ $class_extend_heading='';?>
         <div class="jumbotron"></div>
         <?php  } ?>
         <!-- /jumbotron-->
         <div class="jumbo-heading <?php echo esc_attr($class_extend_heading); ?>">
            <!-- Heading -->
            <h1>
            	<?php 
            	if( isset($theme_option['page_option_general_option_title_header']) && $theme_option['page_option_general_option_title_header'] != '' ){
		          	echo esc_html($theme_option['page_option_general_option_title_header']);
		        }else{
		        	echo esc_html__('Little Ones Blog', 'littleones');
		        }
            	 ?>
            </h1>
            <!-- Breadcrumb -->
            <?php littleones_breadcrumbs(); ?>
         </div>
         <!-- /jumbo-heading -->
         <!-- Blog Home -->
	  <div class="container">
         <div id="blog-container" class="col-md-9">
          <?php
            $args = array(
                'post_type' => 'post',
            );
            $wp_query = new WP_Query( $args ); 
            if($wp_query->have_posts()):
                while ( $wp_query->have_posts() ) : $wp_query->the_post();
                	$format_of_post = get_post_format();
                    if ( false === $format_of_post ) {
                        $format_of_post = 'standard';
                    }
                    if($format_of_post  == 'standard'){
                    	$class_post = 'fa-file-text';
                    } else if($format_of_post  == 'video') {
                    	$class_post = 'fa-film';
                    } else if($format_of_post  == 'image') {
                    	$class_post = 'fa-camera';
                    } else {
                    	$class_post = 'fa-file-text';
                    }
            ?>
            <!-- Blog Post 1 -->
            <div class="blog-post row">
               <div class="img-date">
                  <!-- date and category -->
                  <div class="col-md-1 text-center date-category">
                     <i class="fa <?php echo esc_attr($class_post); ?> fa-2x"></i>
                     <p><?php echo get_the_date('M d, Y',get_the_ID()); ?></p>
                  </div>
                  <!-- blog image -->
                  <div class="img-blog">
                  <?php 
                     $url_img      = get_the_post_thumbnail_url(get_the_ID(),'full');
                     if($url_img){
                        $url_resize   = littleones_resize_thumb( $url_img, 795,353);
                   ?>
                     <a href="<?php get_post_permalink(); ?>"> <img class="img-responsive" src="<?php echo esc_url($url_resize)?>"></a>
                  <?php } ?>
                  </div>
               </div>
               <div class="col-md-12">
                  <!-- Post header -->
                  <h3>
                     <a href="<?php echo get_post_permalink(); ?>"><?php echo get_the_title(); ?></a>
                  </h3>
                  <div class="post-info">
                     <!-- Post Author -->
                     <p><i class="fa fa-user"></i>by <a href="<?php echo get_the_author_link(); ?>"><?php echo get_the_author(); ?></a></p>
                     <!-- Post Comments -->
                     <p><i class="fa fa-comment"></i><a href="#"><?php $count_comment = get_comments_number(); echo is_numeric($count_comment) ? $count_comment:0;  ?> Comments</a></p>
                  </div>
                  <!-- Post Excerpt -->
                  	<?php 
	                    if (isset($theme_option['page_option_general_option_num_excerpt']) && !empty($theme_option['page_option_general_option_num_excerpt']) && $theme_option['page_option_general_option_num_excerpt'] != '') {
	                        $num_excerpt = $theme_option['page_option_general_option_num_excerpt'];
	                    } else {
	                        $num_excerpt = 30;
	                    }
	                ?>
                  <p><?php echo littleones_excerpt($num_excerpt) ?></p>
                  <a class="btn" href="<?php echo get_post_permalink(); ?>"><?php echo esc_html__('Read More','littleones') ?> <i class="fa fa-angle-right"></i></a>
               </div>
            </div>
            <!-- /.row -->
            <?php endwhile; endif; ?>
         </div>
         <!-- /blog-container -->
         <!-- Sidebar Starts -->

         <div class="sidebar col-md-3">
            <?php if(is_active_sidebar('sidebar-1')) dynamic_sidebar('sidebar-1');?>
            <!-- /well -->
         </div>
<!-- /sidebar ends --> 
         <!-- Pagination -->
         <div class="text-center col-md-12">
         	<ul class="pagination">
            <?php littleones_pagination(); ?>
        	</ul>
         </div>
         <!-- /text-center -->
	</div>
      <!-- /container-->
      </div>
      <!-- /container-fluid-->
   </section>
   <!--Section Blog ends -->
</div>
<!--/page-section-->
 <!-- Newsletter -->
<section id="newsletter" class="small-section bg-color1">
    <div class="container text-center text-light">
        <div class="col-md-6">
          <h4><?php if (isset($theme_option['page_option_general_option_text_sub']) && !empty($theme_option['page_option_general_option_text_sub']) && $theme_option['page_option_general_option_text_sub'] != '') { echo esc_html($theme_option['page_option_general_option_text_sub']); } else { echo __('Subscribe to our Newsletter','littleones'); } ?></h4>
        </div>
        <div class="col-md-6">
          <?php 
            if ( shortcode_exists( 'newsletter_form' ) ) {
            if (isset($theme_option['page_option_general_option_num_shortcode']) && !empty($theme_option['page_option_general_option_num_shortcode']) && $theme_option['page_option_general_option_num_shortcode'] != '') { $number_form_newsletter = (int)esc_html($theme_option['page_option_general_option_num_shortcode']); } else { $number_form_newsletter = 1; }
            echo do_shortcode('[newsletter_form form="'.$number_form_newsletter.'"]');
            }
          ?>
        </div>
       <!-- /col-md-6 -->
    </div>
    <!-- /container -->
</section>
  

<?php 
    // Get footer layout
    get_footer();
?>